IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_whorf]')
												 AND type in (N'P', N'PC'))
	DROP PROCEDURE sp_whorf
GO
CREATE PROCEDURE sp_whorf (@Spid Int=0, @Host varchar(50)=null)
as
SELECT
	GETDATE() -r.start_time Tempo
	, s.session_id
	, s.login_name
	, s.host_name
	, DB_NAME(r.database_id) AS DBName
	, SUBSTRING (t.text,(r.statement_start_offset/2) + 1,
	((CASE WHEN r.statement_end_offset = -1
		THEN LEN(CONVERT(NVARCHAR(MAX), t.text)) * 2
		ELSE r.statement_end_offset
	END - r.statement_start_offset)/2) + 1) AS [Individual Query]
	, SUBSTRING(text, 1, 200) AS [Parent Query]
	, r.status
	, r.start_time
	, r.wait_type
	, s.program_name	
	,c.client_net_address
	,s.client_interface_name
FROM 
	sys.dm_exec_sessions s
	INNER JOIN sys.dm_exec_connections c ON s.session_id = c.session_id
	INNER JOIN sys.dm_exec_requests r ON c.connection_id = r.connection_id
	CROSS APPLY sys.dm_exec_sql_text(r.sql_handle) t
WHERE s.session_id > 50
	AND r.session_id != @@spid
	AND CASE WHEN @Spid > 0 THEN s.session_id 
		ELSE @Spid end = @Spid 
	and   s.host_name like CASE WHEN len(@host)>0 then 
											'%'+ @host +'%' else s.host_name end 